/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.whatif;

import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.property.PropertyDefinitions;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import java.util.Map;
import javax.annotation.Nonnull;

public class MaterialWhatIfDecorator
extends Material {
    private final Material originalMaterial;
    private long horizonChange;

    public MaterialWhatIfDecorator(Material originalMaterial) {
        super(originalMaterial.getName());
        this.originalMaterial = originalMaterial;
        this.horizonChange = 0L;
    }

    public long getHorizonChange() {
        return this.horizonChange;
    }

    public void setHorizonChange(long horizonChange) {
        this.horizonChange = horizonChange;
    }

    public void setHorizon(long horizon) {
        this.horizonChange = horizon - this.originalMaterial.getMaterialHorizon();
    }

    @Override
    public long getMaterialHorizon() {
        return GeneralizedRequest.isDateValid(this.originalMaterial.getMaterialHorizon()) ? this.originalMaterial.getMaterialHorizon() + this.horizonChange : this.originalMaterial.getMaterialHorizon();
    }

    @Override
    public String getName() {
        return this.originalMaterial.getName();
    }

    @Override
    public String getDescription() {
        return this.originalMaterial.getDescription();
    }

    @Override
    public boolean isConstant() {
        return this.originalMaterial.isConstant();
    }

    @Override
    public boolean isConsumed() {
        return this.originalMaterial.isConsumed();
    }

    @Override
    public double getMinBatch() {
        return this.originalMaterial.getMinBatch();
    }

    @Override
    public double getMaxBatch() {
        return this.originalMaterial.getMaxBatch();
    }

    @Override
    public double getBatchStep() {
        return this.originalMaterial.getBatchStep();
    }

    @Override
    public double getSafetyStock() {
        return this.originalMaterial.getSafetyStock();
    }

    @Override
    public long getAggregationHorizon() {
        return this.originalMaterial.getAggregationHorizon();
    }

    @Override
    public void setProperties(Map<PropertyDefinition, String> properties, @Nonnull PropertyDefinitions definitions) {
        this.originalMaterial.setProperties(properties, definitions);
    }

    @Override
    public void resetProperties(@Nonnull Map<PropertyDefinition, Object> properties) {
        this.originalMaterial.resetProperties(properties);
    }

    @Override
    public void setProperty(@Nonnull PropertyDefinition pd, Object value) {
        this.originalMaterial.setProperty(pd, value);
    }

    @Override
    public Object getProperty(@Nonnull String name) {
        return this.originalMaterial.getProperty(name);
    }

    @Override
    public Object getProperty(@Nonnull PropertyDefinition def) {
        return this.originalMaterial.getProperty(def);
    }

    @Override
    @Nonnull
    public Map<PropertyDefinition, Object> getProperties() {
        return this.originalMaterial.getProperties();
    }

    public static Material.Builder newBuilder() {
        return Material.newBuilder();
    }
}

